-- todo: remake this screen to only use the real elements since SMOnline sucks
local function Profile(pn)
	if PROFILEMAN:IsPersistentProfile(pn) then
		return PROFILEMAN:GetProfile(pn);
	else
		return PROFILEMAN:GetMachineProfile();
	end;
end;

local function PlayerScore(pn)
	local s = AutoText("frutiger")..{
		Name="Score"..pn;
		InitCommand=cmd(shadowlength,1;diffuse,PlayerColor(pn);player,pn;Stroke,PlayerMidColor(pn));
		OnCommand=cmd(linear,0.2;diffusealpha,1;playcommand,"Set");
		OffCommand=cmd(linear,0.2;diffusealpha,0);

		SetCommand=function(self)
			local SongOrCourse, StepsOrTrail;

			local scorelist;
			local text = "";
			local profile;

			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse();
				StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
			else
				SongOrCourse = GAMESTATE:GetCurrentSong();
				StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
			end;

			if SongOrCourse then
				if StepsOrTrail then
					profile = Profile(pn);
					scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					local topscore = scores[1];
					if not topscore then
						text = string.format("%.2f%%", 0);
					else
						text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
					end;
				else
					text = string.format("%.2f%%", 0);
				end;
			else
				text = string.format("%.2f%%", 0);
			end;
			self:settext(text);
		end;
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentStepsP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;

		CurrentTrailP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentTrailP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
	};

	return s;
end;

local function Difficulty(pn)
	return LoadActor(THEME:GetPathB("ScreenSelectMusic","decorations/PlayerDifficulty") , pn);
	--[[
	local diff = AutoText("frutiger")..{
		Name="Difficulty"..pn;
		InitCommand=cmd(zoom,0.6;shadowlength,1);
		BeginCommand=function(self)
			if GAMESTATE:IsSideJoined(pn) or GAMESTATE:IsPlayerEnabled(pn) then
				self:visible(true)
			else self:visible(false);
			end;
		end;
		OnCommand=cmd(playcommand,"Set");

		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong();
			local course = GAMESTATE:GetCurrentCourse();
			if not song and not course then self:visible(false);
			else self:visible(true);
			end;

			local steps = GAMESTATE:GetCurrentSteps(pn);
			if steps then
				local difficulty = steps:GetDifficulty();
				local diffstring = ( string.sub(difficulty,12) );

				self:diffuse( DifficultyColor(steps:GetDifficulty()) );

				if difficulty == 'Difficulty_Edit' then
					diffstring = steps:GetDescription();
					self:settext(diffstring .. " [" ..steps:GetMeter().."]");
				else
					self:settext(diffstring .. " [" ..steps:GetMeter().."]");
				end;
			else
				self:settext("");
			end;
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");

		CurrentStepsP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentTrailP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentStepsP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
		CurrentTrailP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
	};
	return diff;
	--]]
end;

local t = LoadFallbackB()

t[#t+1] = Def.ActorFrame{
	-- banner section
	Def.ActorFrame{
		Name="BannerSection";
		InitCommand=cmd(x,SCREEN_CENTER_X-156;y,SCREEN_CENTER_Y-102);

		Def.Banner {
			Name="Banner";
			OffCommand=cmd(linear,0.2;diffusealpha,0);
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentSong();
				if not song then self:Load( THEME:GetPathG("common fallback","banner") );
				else self:LoadFromSong(song);
				end;
				self:ScaleToClipped(256,80);
			end;
			InitCommand=cmd(playcommand,"Set");
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		};

		Def.ActorProxy{
			Name="CDTitleProxy";
			InitCommand=cmd(x,8;y,68);
			BeginCommand=function(self)
				local cdtitle = SCREENMAN:GetTopScreen():GetChild('CDTitle');
				self:SetTarget(cdtitle);
			end;
		};

		LoadActor( THEME:GetPathB("","_frame 3x1"), "_bannerframe", 214 ) .. {
			InitCommand=cmd(diffusealpha,0);
			OnCommand=cmd(linear,0.2;diffusealpha,1);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
	};

	-- song length
	Def.ActorFrame{
		Name="LengthSection";
		InitCommand=cmd(x,SCREEN_CENTER_X-40;y,SCREEN_CENTER_Y-156;halign,1;zoom,0.55);
		BeginCommand=cmd(playcommand,"Set");
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			-- check for a song or course. if there isn't one, hide it;
			-- otherwise, display it.
			local song = GAMESTATE:GetCurrentSong();
			local course = GAMESTATE:GetCurrentCourse();

			if song or course then self:visible(true)
			else self:visible(false);
			end;
		end;

		AutoText("frutiger") .. {
			Name="SongLength";
			InitCommand=cmd(shadowlength,0;diffusealpha,0;diffuse,color("#000000"));
			OnCommand=cmd(linear,0.2;diffusealpha,1);
			OffCommand=cmd(linear,0.2;diffusealpha,0);

			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentSong()
				local course = GAMESTATE:GetCurrentCourse()
				if song or course then self:visible(true)
				else self:visible(false); return;
				end;

				local seltime;
				if song then seltime = song:MusicLengthSeconds() end
				if course then
					local st = GAMESTATE:GetCurrentStyle():GetStepsType();
					seltime = course:GetTotalSeconds( st );
				end;
				if seltime then
					local finalText = SecondsToMSSMsMs(seltime);
					self:settext( string.sub(finalText, 0, string.len(finalText)-3) );
				else
					self:settext( "xx:xx" );
				end
			end;
		};
	};

	-- bpm display
	Def.ActorFrame{
		Name="BPMSection";
		InitCommand=cmd(x,SCREEN_CENTER_X-261;y,SCREEN_CENTER_Y-156;halign,0;zoom,0.55);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			-- check for a song or course. if there isn't one, hide it;
			-- otherwise, display it.
			local song = GAMESTATE:GetCurrentSong();
			local course = GAMESTATE:GetCurrentCourse();

			if song or course then self:visible(true)
			else self:visible(false);
			end;
		end;
		Def.BPMDisplay{
			File=IsHighDefinition() and THEME:GetPathF("",fontAliases['frutiger'].Hires) or THEME:GetPathF("",fontAliases['frutiger'].Lores);
			Name="BPMDisplay";
			InitCommand=cmd(x,-4;horizalign,right;shadowlength,0;);
			OnCommand=cmd(stoptweening);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
			SetCommand=function(self) self:SetFromGameState() end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};
		AutoText("frutiger")..{
			Name="BPMLabel";
			InitCommand=cmd(horizalign,left;settext,"BPM";shadowlength,0;diffuse,color("#000000"));
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
	};

	-- 
	Def.ActorFrame{
		Name="Difficulties";
		InitCommand=cmd(x,SCREEN_CENTER_X-156;y,SCREEN_CENTER_Y+132);

		Difficulty(PLAYER_1)..{
			InitCommand=cmd(x,-128;horizalign,left);
		};

		Difficulty(PLAYER_2)..{
			InitCommand=cmd(x,128;horizalign,right);
		};
	};

	-- scores
	Def.ActorFrame{
		Name="ScoresSection";
		InitCommand=cmd(x,SCREEN_CENTER_X-156;y,SCREEN_CENTER_Y+150;zoom,0.75);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			-- check for a song or course. if there isn't one, hide it;
			-- otherwise, display it.
			local song = GAMESTATE:GetCurrentSong();
			local course = GAMESTATE:GetCurrentCourse();

			if song or course then self:visible(true)
			else self:visible(false);
			end;
		end;

		PlayerScore(PLAYER_1)..{
			InitCommand=cmd(x,-172;halign,0);
		};

		PlayerScore(PLAYER_2)..{
			InitCommand=cmd(x,172;halign,1);
		};
	};

	-- song options
	AutoText("frutiger") .. {
		Name="SongOptions";
		InitCommand=cmd(y,150;playcommand,"Set";zoom,0.5;shadowlength,1;diffusealpha,0);
		OnCommand=cmd(linear,0.2;diffusealpha,1);
		OffCommand=cmd(linear,0.2;diffusealpha,0);

		SetCommand=function(self)
			local sText = GAMESTATE:GetSongOptionsString()
			sText = string.gsub(sText, ", ", "\n")
			self:settext( sText )
			if GAMESTATE:IsAnExtraStage() then
				self:diffuseshift();
			end
		end;
		SongOptionsChangedMessageCommand=cmd(playcommand,"Set");
	};
};

return t;

--[[
Copyright  2008-2012 AJ Kelly
All rights reserved.

This code is licensed under AJ's StepMania Theme License.

Terms of the license are as follows:
1) Redistributions of this code must include this license.

2) Under this license, you agree to not claim the theme as your own or
use parts of it without permission. Please contact me if you wish to use this
code in your own themes.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--]]